//
//  FATBaseLoadFailedView.h
//  FinApplet
//
//  Created by luojian on 2021/11/1.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface FATBaseLoadFailedView : UIView

//设置错误提示图片的originY，默认是50
@property (nonatomic, assign) CGFloat errorImageOriginY;

/**
 错误提示图片
 */
@property (nonatomic, strong) UIImageView *errorImageView;
/**
 错误标题
 */
@property (nonatomic, strong) UILabel *errorLabel;
/**
 错误详情
 */
@property (nonatomic, strong) UILabel *detailLabel;
/**
 重新加载按钮
 */
@property (nonatomic, strong) UIButton *reloadButton;

/**
 重新加载block
 */
@property (nonatomic, copy) dispatch_block_t reloadBlock;

//更新主题模式，子类可重写
- (void)updateThemeStyle:(BOOL)isDarkTheme;

@end

NS_ASSUME_NONNULL_END
