//
//  FATMoreMenuHelper.h
//  FinApplet
//
//  Created by 滔 on 2022/5/9.
//  Copyright © 2022 finogeeks. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FATAppletInfo.h"

@interface FATMoreMenuHelper : NSObject

/// 触发转发事件，用来获取转发时用到的小程序信息， 获取到小程序信息后，会触发- (void)forwardAppletWithInfo:(NSDictionary *)contentInfo completion:(void (^)(FATExtensionCode, NSDictionary *))completion 这个回调
/// @param appletId  小程序id
+ (void)invokeForwardMenuAction:(NSString *)appletId;


///  更新小程序的收藏状态
/// @param appletId  小程序id
/// @param favorite  收藏状态
/// @param complete 结果回调，error为nil表示更新成功
+ (void)updateApplet:(NSString *)appletId favoriteStatus:(BOOL)favorite withComplete:(void(^)(NSError *error,FATAppletInfo *appletInfo))complete;

/// 打开小程序的意见反馈页面
/// @param appletId  小程序id
+ (void)goToFeedbackPage:(NSString *)appletId;

/// 打开小程序的关于页面
/// @param appletId  小程序id
+ (void)goToAboutPage:(NSString *)appletId;

/// 打开小程序的设置页面
/// @param appletId  小程序id
+ (void)goToSettingPage:(NSString *)appletId;

/// 打开/关闭小程序的debug模式  如果config设置了enableAppletDebug为FATBOOLStateTrue，执行打开/关闭debug模式操作会无效
/// @param appletId  小程序id
/// @param enable  允许debug模式
+ (void)setEnableAppletDebug:(NSString *)appletId enable:(BOOL)enable;

/// 获取小程序是否打开debug模式
/// @param appletId  小程序id
+ (BOOL)isEnableAppletDebug:(NSString *)appletId;

/// 获取小程序是否已收藏
/// @param appletId  小程序id
+ (BOOL)isAppletFavorite:(NSString *)appletId;

/// 获取自定义菜单项的数据(需要小程序配合实现的菜单项，需要小程序提供额外调用参数)
/// @param appletId  小程序id
/// @param menuId 菜单id
/// @param complete  结果回调
+ (void)getMiniProgramTypeMenuData:(NSString *)appletId menuId:(NSString *)menuId complete:(void(^)(NSDictionary *result,FATAppletInfo *appletInfo))complete;

/// 检测小程序是否实现自定义菜单功能
/// @param appletId  小程序id
/// @param menuIds  自定义菜单ID数组
/// @param complete  结果回调
+ (void)checkMenus:(NSString *)appletId menuIds:(NSArray<NSString *> *)menuIds complete:(void(^)(NSArray *result))complete;

@end

