//
//  FATBDMapComponent.h
//  FinAppletBDMap
//
//  Created by 王滔 on 2021/11/29.
//

#import <Foundation/Foundation.h>
#import <BaiduMapAPI_Base/BMKBaseComponent.h>

NS_ASSUME_NONNULL_BEGIN

@interface FATBDMapComponent : NSObject

+ (NSString *)SDKVersion;

/// 设置百度地图的appkey和一些初始化工作，请注意，需要先调用隐私合格政策的Api
/// @param appkey 地图的appkey
+ (void)setBDMapAppKey:(NSString *)appkey;

/// 百度地图的一些配置项的准备工作,如果在宿主App内已经引用了百度SDK并初始化了，不想再重复初始化，可以使用这个方法，请注意，需要先调用隐私合格政策的Api
+ (void)registerComponent;

/// 设置百度地图的坐标系类型
/// @param coordinateType 地图的坐标系类型
+ (BOOL)setBDMapCoordinateType:(BMK_COORD_TYPE)coordinateType;

/**
 *@brief 更新是否同意隐私合格政策需要在BMKLocationManager和BMKGeoFenceManager实例化之前调用，否则实例化失败，定位功能不可用。
 *       在使用BMKLocationManager和BMKGeoFenceManager时，请注意需要加判空处理。
 *       隐私政策官网链接：https://lbsyun.baidu.com/index.php?title=openprivacy
 *
 *       note:隐私政策变更后需要重新初始化BMKLocationManager或BMKGeoFenceManager
 *@param agreePrivacy 是否同意
 */
+ (void)setAgreePrivacy:(BOOL)agreePrivacy;

@end

NS_ASSUME_NONNULL_END
