//
//  FATGDMapComponent.h
//  FinAppletGDMap
//
//  Created by 王滔 on 2021/11/24.
//

#import <Foundation/Foundation.h>
#import <MAMapKit/MAMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface FATGDMapComponent : NSObject

/// 高德地图扩展SDK版本号
+ (NSString *)SDKVersion;

/// 设置高德地图的appkey和一些初始化工作
/// @param appkey 地图的appkey
+ (void)setGDMapAppKey:(NSString *)appkey;


/// 高德地图的一些配置项的准备工作,如果在宿主App内已经引用了高德SDK并初始化了，不想再重复初始化，可以使用这个方法
+ (void)registerComponent;

/// 在使用地图功能和搜索功能前需要展示用户授权弹窗，包含高德SDK隐私协议并且授权高德SDK隐私协议后，方可正常使用地图功能，否则无法正常使用
/// @param showStatus 显示隐私弹窗状态  -1: unknow , 0 : 未显示 ， 1 ： 已显示
/// @param containStatus 集成SDK隐私信息状态  -1: unknow , 0 : 未集成 ， 1 ： 已集成
/// @param agreeStatus 用户同意隐私状态 -1: unknow , 0 : 未同意 ， 1 ： 已同意
+ (void)setGDMapPrivacyShow:(AMapPrivacyShowStatus)showStatus privacyInfo:(AMapPrivacyInfoStatus)containStatus PrivacyAgreement:(AMapPrivacyAgreeStatus)agreeStatus;

@end

NS_ASSUME_NONNULL_END
