//
//  FATTXMapComponent.h
//  FinAppletTXMap
//
//  Created by 王兆耀 on 2022/10/17.
//

#import <Foundation/Foundation.h>
#import <QMapKit/QMapKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface FATTXMapComponent : NSObject

+ (NSString *)SDKVersion;

/**
 * 设置腾讯地图的appkey和一些初始化工作
 * @param appkey 地图的appkey
 */
+ (void)setTXMapAppKey:(NSString *)appkey;

/**
 * 设置腾讯地图的web Secret key
 * @param webSecretKey 腾讯地图的web Secret key
 */
+ (void)setTXMapWebSecretKey:(NSString *)webSecretKey;

/**
 * @brief 隐私合规接口, 必须在地图和定位功能初始化前调用, 默认为false
 *        设置为false, 地图实例返回nil, 地图功能不能使用，TencentLBSLocationManager初始化不成功，返回nil，定位功能均无法使用
 *        隐私政策官网: https://lbs.qq.com/userAgreements/agreements/privacy
 */
+ (void)setPrivacyAgreement:(BOOL)isAgree;

@end

NS_ASSUME_NONNULL_END
